/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.fabric.api.zen.factory;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.action.RegisterObjectAction;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.fabric.api.util.CustomTier;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.blamejared.contenttweaker.vanilla.api.zen.factory.TierFactory;
import com.blamejared.contenttweaker.vanilla.api.zen.object.ItemReference;
import com.blamejared.contenttweaker.vanilla.api.zen.object.TierReference;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.util.NameUtil;
import java.util.List;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Expansion(value="contenttweaker.factory.vanilla.TierFactory")
@ZenRegister(loaders={"contenttweaker"})
public final class FabricTierFactoryExpansions {
    private FabricTierFactoryExpansions() {
    }

    @ZenCodeType.Method(value="create")
    public static TierReference of(TierFactory $this, String name, int level, int uses, float speed, float attackDamageBonus, int enchantmentValue, ItemReference repairItem) {
        class_2960 tierName = ContentTweakerConstants.rl(NameUtil.fixing((String)name, (fixed, mistakes) -> FabricTierFactoryExpansions.report(name, fixed, mistakes)));
        if (level < 0) {
            throw new IllegalArgumentException("Level for tier " + tierName + " cannot be negative");
        }
        if (uses <= 0) {
            throw new IllegalArgumentException("Uses for tier " + tierName + " cannot be negative or zero");
        }
        ObjectHolder<class_1832> holder = ObjectHolder.of(VanillaObjectTypes.TIER, tierName, () -> CustomTier.of(uses, speed, attackDamageBonus, level, enchantmentValue, () -> class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)repairItem.get()})));
        ContentTweakerApi.apply(RegisterObjectAction.of(holder));
        return TierReference.of(tierName);
    }

    private static void report(String original, String fixed, List<String> mistakes) {
        CraftTweakerAPI.LOGGER.warn(() -> "The given name '%s' is not valid: it has been fixed to '%s'.\nMistakes:%s".formatted(original, fixed, String.join((CharSequence)"\n", mistakes)));
    }
}

