/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.fabric.api.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.vanilla.api.object.VanillaObjectTypes;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_2960;

public final class TierRegistry
implements GameRegistry<class_1832> {
    private final BiMap<class_2960, class_1832> knownTiers;
    private final BiMap<class_1832, class_2960> inverse;

    private TierRegistry(Supplier<Map<class_2960, class_1832>> vanillaTiers) {
        this.knownTiers = HashBiMap.create(vanillaTiers.get());
        this.inverse = this.knownTiers.inverse();
    }

    public static TierRegistry of() {
        return new TierRegistry(TierRegistry::vanillaTiers);
    }

    private static Map<class_2960, class_1832> vanillaTiers() {
        return Arrays.stream(class_1834.values()).collect(Collectors.toMap(it -> new class_2960(it.name().toLowerCase(Locale.ENGLISH)), Function.identity()));
    }

    @Override
    public ObjectType<class_1832> type() {
        return VanillaObjectTypes.TIER;
    }

    @Override
    public class_1832 get(class_2960 name) {
        return (class_1832)this.knownTiers.get((Object)Objects.requireNonNull(name));
    }

    @Override
    public class_2960 nameOf(class_1832 tier) {
        return (class_2960)this.inverse.computeIfAbsent((Object)Objects.requireNonNull(tier), it -> {
            throw new IllegalStateException("No such tier with name " + it + " is known: either it does not exist or it was not found");
        });
    }

    @Override
    public Collection<class_1832> all() {
        return this.knownTiers.values();
    }

    @Override
    public void enqueueRegistration(class_2960 name, Supplier<class_1832> objectCreator) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(objectCreator);
        if (this.knownTiers.containsKey((Object)name)) {
            throw new IllegalArgumentException("A tier with name '" + name + "' was already registered");
        }
        this.knownTiers.put((Object)name, (Object)objectCreator.get());
    }
}

