/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.zen.bracket;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.object.ReferenceFactory;
import com.blamejared.contenttweaker.core.api.registry.GameRegistry;
import com.blamejared.contenttweaker.core.api.zen.bracket.BracketHelper;
import com.blamejared.contenttweaker.core.api.zen.bracket.ReferenceExpression;
import com.blamejared.contenttweaker.core.api.zen.object.Reference;
import com.blamejared.crafttweaker.api.util.ParseUtil;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedExpression;

final class ReferenceBracketExpressionParser
implements BracketExpressionParser {
    ReferenceBracketExpressionParser() {
    }

    public static Stream<String> dump() {
        return ContentTweakerCore.core().metaRegistry().objectTypes().allTypes().stream().flatMap(ReferenceBracketExpressionParser::makeEntryData).sorted().map(EntryData::toString);
    }

    private static <T> Stream<EntryData> makeEntryData(ObjectType<T> type) {
        class_2960 id = type.id();
        GameRegistry<T> registry = ReferenceBracketExpressionParser.registryOf(type);
        return registry.stream().map(registry::nameOf).map(it -> new EntryData(id, (class_2960)it));
    }

    private static <T> GameRegistry<T> registryOf(ObjectType<T> type) {
        return ContentTweakerCore.core().metaRegistry().registryResolvers().findResolverFor(type).registry();
    }

    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        String contents = ParseUtil.readBracketContent((CodePosition)position, (ZSTokenParser)tokens);
        int colons = contents.replaceAll("[^:]", "").length();
        String[] split = contents.split(Pattern.quote(":"), 4);
        return switch (colons) {
            case 1 -> this.parseVanillaVanilla(position, split);
            case 2 -> this.parseVanillaModded(position, split);
            case 3 -> this.parseModdedModded(position, split);
            default -> throw this.fail(position, contents);
        };
    }

    private ParsedExpression parseVanillaVanilla(CodePosition position, String[] content) throws ParseException {
        assert (content.length == 2);
        class_2960 registry = BracketHelper.locationOrThrow(position, content[0]);
        class_2960 id = BracketHelper.locationOrThrow(position, content[1]);
        return this.createExpression(position, registry, id);
    }

    private ParsedExpression parseVanillaModded(CodePosition position, String[] content) throws ParseException {
        assert (content.length == 3);
        class_2960 registry = BracketHelper.locationOrThrow(position, content[0]);
        class_2960 id = BracketHelper.locationOrThrow(position, content[1] + ":" + content[2]);
        return this.createExpression(position, registry, id);
    }

    private ParsedExpression parseModdedModded(CodePosition position, String[] content) throws ParseException {
        assert (content.length == 4);
        class_2960 registry = BracketHelper.locationOrThrow(position, content[0] + ":" + content[1]);
        class_2960 id = BracketHelper.locationOrThrow(position, content[2] + ":" + content[3]);
        return this.createExpression(position, registry, id);
    }

    private ParsedExpression createExpression(CodePosition position, class_2960 typeId, class_2960 id) throws ParseException {
        return this.createExpression(position, typeId, this.grabType(typeId), id);
    }

    private <T, U extends Reference<T>> ParsedExpression createExpression(CodePosition position, class_2960 typeId, ObjectType<T> type, class_2960 id) throws ParseException {
        if (type == null) {
            throw new ParseException(position, "The given type " + typeId + " is not known: unable to construct a reference to it");
        }
        ReferenceFactory factory = ContentTweakerCore.core().metaRegistry().referenceFactories().findFactoryFor(type);
        return new ReferenceExpression(position, type, factory.type(), id);
    }

    private ParseException fail(CodePosition position, String contents) throws ParseException {
        String message = "Invalid contents \"" + contents + "\" for reference bracket: expected bracket in format <reference:typeNamespace:typeId:objectNamespace:objectId> or one of the following short-hand forms: <reference:typeId:objectId>, <reference:typeId:objectNamespace:objectId>";
        throw new ParseException(position, message);
    }

    private <T> ObjectType<T> grabType(class_2960 typeId) {
        return ContentTweakerCore.core().metaRegistry().objectTypes().get(typeId);
    }

    private record EntryData(class_2960 type, class_2960 object) implements Comparable<EntryData>
    {
        private static final Comparator<class_2960> BETTER_RL_COMPARATOR = Comparator.comparing(class_2960::method_12836).thenComparing(class_2960::method_12832);
        private static final Comparator<EntryData> ENTRY_DATA_COMPARATOR = Comparator.comparing(EntryData::type, BETTER_RL_COMPARATOR).thenComparing(EntryData::object, BETTER_RL_COMPARATOR);

        @Override
        public int compareTo(EntryData o) {
            return ENTRY_DATA_COMPARATOR.compare(this, o);
        }

        @Override
        public String toString() {
            return "<reference:%s:%s>".formatted(this.type(), this.object());
        }
    }
}

