/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.zen.bracket;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.object.ObjectFactory;
import com.blamejared.contenttweaker.core.api.object.ObjectFactoryMapping;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.zen.bracket.BracketHelper;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.util.ParseUtil;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.api.zencode.IZenClassRegistry;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.type.IParsedType;

final class FactoryBracketExpressionParser
implements BracketExpressionParser {
    FactoryBracketExpressionParser() {
    }

    public static Stream<String> dump() {
        return ContentTweakerCore.core().metaRegistry().objectTypes().allTypes().stream().map(ObjectType::id).map(class_2960::toString).sorted().map(arg_0 -> FactoryBracketExpressionParser.lambda$dump$0("<factory:%s>", arg_0));
    }

    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        class_2960 id = this.findRegistryId(position, tokens);
        return this.createExpression(position, id);
    }

    private class_2960 findRegistryId(CodePosition position, ZSTokenParser tokens) throws ParseException {
        String bracketContents = ParseUtil.readBracketContent((CodePosition)position, (ZSTokenParser)tokens);
        return BracketHelper.locationOrThrow(position, bracketContents, () -> "Expected an object type identifier in the form <factory:modid:name>, but instead found " + bracketContents);
    }

    private <T> ParsedExpression createExpression(CodePosition position, class_2960 typeId) throws ParseException {
        ObjectType<T> type = this.grabType(position, typeId);
        return new BracketMetaFactoryExpression(position, type, this.grabFactoryMapping(type));
    }

    private <T> ObjectType<T> grabType(CodePosition position, class_2960 typeId) throws ParseException {
        ObjectType type = ContentTweakerCore.core().metaRegistry().objectTypes().get(typeId);
        if (type == null) {
            throw new ParseException(position, "Type for '" + typeId + "' is not known: unable to create a factory for it");
        }
        return type;
    }

    private <T, U extends ObjectFactory<T>> ObjectFactoryMapping<T, U> grabFactoryMapping(ObjectType<T> type) {
        return ContentTweakerCore.core().metaRegistry().factoryMappings().findMappingFor(type);
    }

    private static /* synthetic */ String lambda$dump$0(String rec$, Object xva$0) {
        return "<factory:%s>".formatted(xva$0);
    }

    private static final class BracketMetaFactoryExpression<T, U extends ObjectFactory<T>>
    extends ParsedExpression {
        private final ObjectType<T> type;
        private final ObjectFactoryMapping<T, U> factoryMapping;

        BracketMetaFactoryExpression(CodePosition position, ObjectType<T> type, ObjectFactoryMapping<T, U> factoryMapping) {
            super(position);
            this.type = type;
            this.factoryMapping = factoryMapping;
        }

        public IPartialExpression compile(ExpressionScope scope) throws CompileException {
            ParsedExpression runtimeClass = ParseUtil.staticMemberExpression((CodePosition)this.position, (String)"contenttweaker._rt.MetaFactory");
            ParsedExpressionMember factoryMethod = new ParsedExpressionMember(this.position, runtimeClass, "factory", null);
            ParsedCallArguments arguments = this.makeCall();
            ParsedExpressionCall invocation = new ParsedExpressionCall(this.position, (ParsedExpression)factoryMethod, arguments);
            return invocation.compile(scope);
        }

        public boolean hasStrongType() {
            return true;
        }

        private ParsedCallArguments makeCall() throws CompileException {
            return new ParsedCallArguments(List.of(this.findTypeGeneric(), this.findFactoryGeneric()), List.of(this.findArgument()));
        }

        private IParsedType findTypeGeneric() throws CompileException {
            return this.readParsedType(this.type.type());
        }

        private IParsedType findFactoryGeneric() throws CompileException {
            return this.readParsedType(this.factoryMapping.type());
        }

        private ParsedExpression findArgument() throws CompileException {
            return BracketHelper.parseToCompile(this.position, () -> BracketHelper.locationArgument(this.position, this.type.id()));
        }

        private <L> IParsedType readParsedType(Class<L> type) throws CompileException {
            return BracketHelper.parseToCompile(this.position, () -> ParseUtil.readParsedType((String)this.findClassNameFor(type), (CodePosition)this.position));
        }

        private <L> String findClassNameFor(Class<L> type) {
            IScriptLoader loader = CraftTweakerAPI.getScriptRunManager().currentRunInfo().loader();
            IZenClassRegistry classes = CraftTweakerAPI.getRegistry().getZenClassRegistry();
            return (String)classes.getNameFor(loader, type).orElseThrow();
        }
    }
}

