/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.util;

import com.blamejared.contenttweaker.core.util.FreezableCollection;
import com.blamejared.contenttweaker.core.util.FreezableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FreezableMap<K, V>
implements Map<K, V> {
    private final Map<K, V> delegate;
    private final AtomicBoolean frozen;
    private final boolean ownership;

    private FreezableMap(Map<K, V> delegate, AtomicBoolean frozen, boolean ownership) {
        this.delegate = delegate;
        this.frozen = frozen;
        this.ownership = ownership;
    }

    public static <K, V> FreezableMap<K, V> of() {
        return FreezableMap.of(new HashMap());
    }

    public static <K, V> FreezableMap<K, V> of(Map<K, V> delegate) {
        return FreezableMap.of(delegate, false);
    }

    public static <K, V> FreezableMap<K, V> of(Map<K, V> delegate, boolean frozen) {
        return new FreezableMap<K, V>(delegate, new AtomicBoolean(frozen), true);
    }

    static <K, V> FreezableMap<K, V> of(Map<K, V> delegate, AtomicBoolean frozen) {
        return new FreezableMap<K, V>(delegate, frozen, false);
    }

    public void freeze() {
        if (!this.ownership) {
            throw new UnsupportedOperationException("freeze: Depends on another freezable object");
        }
        this.frozen.set(true);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("put: Map is frozen");
        }
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("remove: Map is frozen");
        }
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("putAll: Map is frozen");
        }
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("clear: Map is frozen");
        }
        this.delegate.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return FreezableSet.of(this.delegate.keySet(), this.frozen);
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return FreezableCollection.of(this.delegate.values(), this.frozen);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return FreezableSet.of(this.delegate.entrySet(), this.frozen);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("replaceAll: Map is frozen");
        }
        this.delegate.replaceAll(function);
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("putIfAbsent: Map is frozen");
        }
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("remove: Map is frozen");
        }
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("replace: Map is frozen");
        }
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    @Nullable
    public V replace(K key, V value) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("replace: Map is frozen");
        }
        return this.delegate.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, @NotNull Function<? super K, ? extends V> mappingFunction) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("computeIfAbsent: Map is frozen");
        }
        return this.delegate.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("computeIfPresent: Map is frozen");
        }
        return this.delegate.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("compute: Map is frozen");
        }
        return this.delegate.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, @NotNull V value, @NotNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (this.frozen.get()) {
            throw new UnsupportedOperationException("merge: Map is frozen");
        }
        return this.delegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }
}

