/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleException;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class TrundleResource {
    private final String name;
    private final Type type;
    private final Map<String, FileAttribute<?>> attributes;

    TrundleResource(String name, Type type, Collection<FileAttribute<?>> attributes) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.attributes = TrundleFileAttributes.bake(Objects.requireNonNull(attributes).stream().collect(Collectors.toMap(FileAttribute::name, Function.identity())));
    }

    final String name() {
        return this.name;
    }

    final Type type() {
        return this.type;
    }

    final Collection<FileAttribute<?>> attributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    final TrundleFileAttributes attributesObject() {
        return TrundleFileAttributes.of(this, this.attributes);
    }

    abstract void add(TrundleResource var1);

    abstract void remove(TrundleResource var1);

    abstract TrundleResource tryResolve(String var1);

    abstract byte[] contents();

    abstract long size();

    final TrundleResource resolve(String name) {
        TrundleResource resource = this.tryResolve(name);
        if (resource == null) {
            throw new TrundleException(TrundleException.Code.RESOLUTION_ERROR, "Unable to resolve child '" + name + "'", new NullPointerException());
        }
        return resource;
    }

    static enum Type {
        DIRECTORY,
        FILE;

    }
}

