/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleFileSystem;
import com.blamejared.contenttweaker.core.resource.trundle.TrundlePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class TrundleFileSystemProvider
extends FileSystemProvider {
    public static final String SCHEME = "trundle";
    private final Map<String, TrundleFileSystem> fileSystems = new HashMap<String, TrundleFileSystem>();

    @Override
    public String getScheme() {
        return SCHEME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.checkUri(uri);
        String name = this.findName(uri);
        Map<String, TrundleFileSystem> map = this.fileSystems;
        synchronized (map) {
            if (this.fileSystems.containsKey(name)) {
                throw new FileSystemAlreadyExistsException("Already created Trundle file system with name " + name);
            }
            TrundleFileSystem fs = TrundleFileSystem.of(this, name, env);
            this.fileSystems.put(name, fs);
            return fs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(URI uri) {
        this.checkUri(uri);
        String name = this.findName(uri);
        Map<String, TrundleFileSystem> map = this.fileSystems;
        synchronized (map) {
            TrundleFileSystem fs = this.fileSystems.get(name);
            if (fs == null) {
                throw new FileSystemNotFoundException("No such Trundle file system with name " + name);
            }
            return fs;
        }
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        this.checkUri(uri);
        String path = uri.getRawSchemeSpecificPart().split(Pattern.quote("@"), 2)[1];
        if (path.isEmpty()) {
            throw new IllegalArgumentException("URI " + uri + " does not contain path");
        }
        return this.getFileSystem(uri).getPath(path, new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(options);
        Objects.requireNonNull(attrs);
        return this.trundlePath(path).seekableByteChannel(options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Objects.requireNonNull(dir);
        Objects.requireNonNull(filter);
        return this.trundlePath(dir).directoryStream(filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Objects.requireNonNull(dir);
        Objects.requireNonNull(attrs);
        this.trundlePath(dir).createDirectory(attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        Objects.requireNonNull(path);
        this.trundlePath(path).delete();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        Objects.requireNonNull(source);
        Objects.requireNonNull(target);
        Objects.requireNonNull(options);
        this.trundlePath(source).copy(this.trundlePath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        Objects.requireNonNull(source);
        Objects.requireNonNull(target);
        Objects.requireNonNull(options);
        this.trundlePath(source).move(this.trundlePath(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        if (path == path2) {
            return true;
        }
        if (!(path2 instanceof TrundlePath)) {
            return false;
        }
        TrundlePath other = (TrundlePath)path2;
        return this.trundlePath(path).isSameFile(other);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        Objects.requireNonNull(path);
        return this.trundlePath(path).isHidden();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        Objects.requireNonNull(path);
        return this.trundlePath(path).fileStore();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(modes);
        this.trundlePath(path).checkAccess(modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(type);
        Objects.requireNonNull(options);
        return this.trundlePath(path).fileAttributeView(type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(type);
        Objects.requireNonNull(options);
        return this.trundlePath(path).attributes(type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(attributes);
        Objects.requireNonNull(options);
        return this.trundlePath(path).attributes(attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(attribute);
        Objects.requireNonNull(value);
        Objects.requireNonNull(options);
        this.trundlePath(path).attribute(attribute, value, options);
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(env);
        throw new UnsupportedOperationException("Unable to access '" + path + "' as a Trundle file system");
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(options);
        return this.trundlePath(path).inputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(options);
        return this.trundlePath(path).outputStream(options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(options);
        Objects.requireNonNull(attrs);
        return this.trundlePath(path).fileChannel(options, attrs);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(options);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(attrs);
        return this.trundlePath(path).asyncFileChannel(options, executor, attrs);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
        Objects.requireNonNull(link);
        Objects.requireNonNull(target);
        Objects.requireNonNull(attrs);
        throw new UnsupportedOperationException("Symbolic link creation is not supported in a Trundle file system");
    }

    @Override
    public void createLink(Path link, Path existing) {
        Objects.requireNonNull(link);
        Objects.requireNonNull(existing);
        throw new UnsupportedOperationException("Link creation is not supported in a Trundle file system");
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        Objects.requireNonNull(path);
        return this.trundlePath(path).deleteIfExists();
    }

    @Override
    public Path readSymbolicLink(Path link) {
        Objects.requireNonNull(link);
        throw new UnsupportedOperationException("Symbolic link reading is not supported in a Trundle file system");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileSystem(String name) {
        Map<String, TrundleFileSystem> map = this.fileSystems;
        synchronized (map) {
            this.fileSystems.remove(name);
        }
    }

    private void checkUri(URI uri) {
        Objects.requireNonNull(uri);
        if (!uri.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException("Unable to create a file system with a non-" + this.getScheme() + " URI");
        }
        String raw = uri.getRawSchemeSpecificPart();
        if (!raw.contains("@")) {
            throw new IllegalArgumentException("Invalid URL for " + this.getScheme() + " URI: missing type marker");
        }
    }

    private String findName(URI uri) {
        String raw = uri.getRawSchemeSpecificPart();
        String[] splits = raw.split(Pattern.quote("@"), 2);
        return splits[0];
    }

    private TrundlePath trundlePath(Path path) {
        if (!(path instanceof TrundlePath)) {
            throw new ProviderMismatchException("Mismatch with path " + path);
        }
        TrundlePath trundlePath = (TrundlePath)path;
        return trundlePath;
    }
}

