/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleFile;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class TrundleFileChannel
extends FileChannel {
    private final Lock lock = new ReentrantLock(true);
    private final TrundleFile resource;
    private final boolean read;
    private final boolean write;
    private final boolean appending;
    private long position;

    TrundleFileChannel(TrundleFile resource, boolean read, boolean write, long position) {
        this.resource = resource;
        this.read = read;
        this.write = write;
        this.position = position;
        this.appending = position != 0L;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        Objects.requireNonNull(dst);
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Unable to fill a read-only buffer");
        }
        if (!this.read) {
            throw new NonReadableChannelException();
        }
        this.checkOpen();
        this.lock.lock();
        try {
            byte[] contents = this.resource.contents();
            int available = contents.length - (int)this.position;
            if (available <= 0) {
                int n = -1;
                return n;
            }
            int remaining = dst.remaining();
            int readAmount = Math.min(available, remaining);
            dst.put(contents, (int)this.position, readAmount);
            this.position += (long)readAmount;
            int n = readAmount;
            return n;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException e) {
            throw new IOException("Unable to read from resource into buffer", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        Objects.requireNonNull(dsts);
        Objects.checkFromIndexSize(offset, length, dsts.length);
        for (ByteBuffer buffer : dsts) {
            if (!buffer.isReadOnly()) continue;
            throw new IllegalArgumentException("Unable to fill a read-only buffer");
        }
        if (!this.read) {
            throw new NonReadableChannelException();
        }
        this.checkOpen();
        this.lock.lock();
        try {
            byte[] contents = this.resource.contents();
            int available = contents.length - (int)this.position;
            if (available <= 0) {
                long l = -1L;
                return l;
            }
            long rollingTotal = 0L;
            int l = offset + length;
            for (int i = offset; i < l; ++i) {
                ByteBuffer buffer = dsts[i];
                int remainingForBuffer = buffer.remaining();
                int readAmount = Math.min(available, remainingForBuffer);
                buffer.put(contents, (int)this.position, readAmount);
                this.position += (long)readAmount;
                rollingTotal += (long)readAmount;
                available = contents.length - (int)this.position;
            }
            long l2 = rollingTotal;
            return l2;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException e) {
            throw new IOException("Unable to read from resource into buffers", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        Objects.requireNonNull(src);
        if (!this.write) {
            throw new NonWritableChannelException();
        }
        this.checkOpen();
        this.lock.lock();
        long savedPosition = this.position;
        try {
            int remaining;
            int available;
            byte[] contents = this.resource.contents();
            if (this.appending) {
                this.position = contents.length;
            }
            byte[] newContents = (available = contents.length - (int)this.position) < (remaining = src.remaining()) ? this.resource.resizeContents(remaining - available) : contents;
            src.get(newContents, (int)this.position, remaining);
            this.position += (long)remaining;
            int n = remaining;
            return n;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            this.position = savedPosition;
            throw new IOException("Unable to write data to the resource", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        Objects.requireNonNull(srcs);
        Objects.checkFromIndexSize(offset, length, srcs.length);
        if (!this.write) {
            throw new NonWritableChannelException();
        }
        this.checkOpen();
        this.lock.lock();
        long savedPosition = this.position;
        try {
            byte[] contents = this.resource.contents();
            if (this.appending) {
                this.position = contents.length;
            }
            int available = contents.length - (int)this.position;
            byte[] newContents = contents;
            long rollingTotal = 0L;
            int l = offset + length;
            for (int i = offset; i < l; ++i) {
                ByteBuffer buffer = srcs[i];
                int remainingForBuffer = buffer.remaining();
                if (available < remainingForBuffer) {
                    int increase = remainingForBuffer - available;
                    newContents = this.resource.resizeContents(increase);
                }
                buffer.get(newContents, (int)this.position, remainingForBuffer);
                this.position += (long)remainingForBuffer;
                rollingTotal += (long)remainingForBuffer;
                available = contents.length - (int)this.position;
            }
            long l2 = rollingTotal;
            return l2;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            this.position = savedPosition;
            throw new IOException("Unable to write data to the resource", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("Unable to set a negative position");
        }
        this.checkOpen();
        this.lock.lock();
        try {
            this.position = newPosition;
            TrundleFileChannel trundleFileChannel = this;
            return trundleFileChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long size() throws IOException {
        this.checkOpen();
        return this.resource.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("Unable to truncate to a negative size");
        }
        if (!this.write) {
            throw new NonWritableChannelException();
        }
        this.checkOpen();
        if (this.appending) {
            throw new IOException("The resource cannot be truncated");
        }
        this.lock.lock();
        try {
            byte[] contents = this.resource.contents();
            int currentSize = contents.length;
            if ((long)currentSize > size) {
                int reduce = (int)size - currentSize;
                this.resource.resizeContents(reduce);
            }
            TrundleFileChannel trundleFileChannel = this;
            return trundleFileChannel;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Unable to truncate resource", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.checkOpen();
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        Objects.requireNonNull(target);
        if (position < 0L || count < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.read) {
            throw new NonReadableChannelException();
        }
        this.checkOpen();
        this.lock.lock();
        try {
            ByteBuffer readBuffer = ByteBuffer.allocate((int)count).order(ByteOrder.nativeOrder());
            byte[] contents = this.resource.contents();
            long available = (long)contents.length - position;
            int readAmount = (int)Math.min(available, count);
            readBuffer.put(contents, (int)position, readAmount);
            readBuffer.flip();
            long l = target.write(readBuffer);
            return l;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException e) {
            throw new IOException("Unable to transfer from resource to channel", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        Objects.requireNonNull(src);
        if (position < 0L || count < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.write) {
            throw new NonWritableChannelException();
        }
        this.checkOpen();
        this.lock.lock();
        try {
            byte[] contents = this.resource.contents();
            if (this.appending && this.position != (long)contents.length) {
                throw new IOException("Resource is opened in append mode, but position is incompatible");
            }
            ByteBuffer writeBuffer = ByteBuffer.allocate((int)count).order(ByteOrder.nativeOrder());
            src.read(writeBuffer);
            writeBuffer.flip();
            int remaining = writeBuffer.remaining();
            int available = (int)((long)contents.length - position);
            byte[] newContents = available < remaining ? this.resource.resizeContents(remaining - available) : contents;
            writeBuffer.get(newContents, (int)position, remaining);
            long l = remaining;
            return l;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new IOException("Unable to transfer from channel to resource", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        Objects.requireNonNull(dst);
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Unable to fill a read-only buffer");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (!this.read) {
            throw new NonReadableChannelException();
        }
        this.checkOpen();
        this.lock.lock();
        try {
            byte[] contents = this.resource.contents();
            int available = contents.length - (int)position;
            if (available <= 0) {
                int n = -1;
                return n;
            }
            int remaining = dst.remaining();
            int readAmount = Math.min(available, remaining);
            dst.put(contents, (int)position, readAmount);
            int n = readAmount;
            return n;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException e) {
            throw new IOException("Unable to read from resource into buffer", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        Objects.requireNonNull(src);
        if (position < 0L) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (!this.write) {
            throw new NonWritableChannelException();
        }
        this.checkOpen();
        this.lock.lock();
        try {
            byte[] contents = this.resource.contents();
            if (this.appending && position != (long)contents.length) {
                throw new IOException("Resource is opened in append mode, but position is incompatible");
            }
            int available = contents.length - (int)position;
            int remaining = src.remaining();
            byte[] newContents = available < remaining ? this.resource.resizeContents(remaining - available) : contents;
            src.get(newContents, (int)position, remaining);
            int n = remaining;
            return n;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new IOException("Unable to write data to the resource", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        Objects.requireNonNull(mode);
        if (position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        throw new IOException(new UnsupportedOperationException("Not yet implemented"));
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L || position + size < 0L) {
            throw new IllegalArgumentException();
        }
        throw new IOException(new UnsupportedOperationException("Not yet implemented"));
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (position < 0L || size < 0L || position + size < 0L) {
            throw new IllegalArgumentException();
        }
        throw new IOException(new UnsupportedOperationException("Not yet implemented"));
    }

    @Override
    protected void implCloseChannel() {
    }

    private void checkOpen() throws IOException {
        if (this.closed()) {
            throw new ClosedChannelException();
        }
    }

    private boolean closed() {
        return !this.isOpen();
    }
}

