/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleFileAttributes;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleResource;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Objects;

final class TrundleFileAttributesView
implements DosFileAttributeView {
    private final String name;
    private final ThrowingSupplier<TrundleFileAttributes, IOException> attributes;

    private TrundleFileAttributesView(String name, ThrowingSupplier<TrundleFileAttributes, IOException> attributes) {
        this.name = name;
        this.attributes = new MemoizingThrowingSupplier<TrundleFileAttributes, IOException>(attributes);
    }

    static <A extends FileAttributeView> TrundleFileAttributesView of(TrundleResource resource, Class<A> type) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(type);
        return new TrundleFileAttributesView(TrundleFileAttributesView.classToName(type), () -> TrundleFileAttributes.of(resource));
    }

    private static <A extends FileAttributeView> String classToName(Class<A> type) {
        if (type == BasicFileAttributeView.class) {
            return "basic";
        }
        if (type == DosFileAttributeView.class) {
            return "dos";
        }
        throw new IllegalArgumentException(type.getName());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DosFileAttributes readAttributes() throws IOException {
        return this.attributes.get();
    }

    @Override
    public void setReadOnly(boolean value) throws IOException {
        this.attributes.get().setReadOnly(value);
    }

    @Override
    public void setHidden(boolean value) throws IOException {
        this.attributes.get().setHidden(value);
    }

    @Override
    public void setSystem(boolean value) throws IOException {
        this.attributes.get().setSystem(value);
    }

    @Override
    public void setArchive(boolean value) throws IOException {
        this.attributes.get().setArchive(value);
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.attributes.get().setTimes(lastModifiedTime, lastAccessTime, createTime);
    }

    private static final class MemoizingThrowingSupplier<T, E extends Exception>
    implements ThrowingSupplier<T, E> {
        private volatile ThrowingSupplier<T, E> delegate;
        private volatile boolean initialized;
        private T result;

        private MemoizingThrowingSupplier(ThrowingSupplier<T, E> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
            this.initialized = false;
            this.result = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws E {
            if (!this.initialized) {
                MemoizingThrowingSupplier memoizingThrowingSupplier = this;
                synchronized (memoizingThrowingSupplier) {
                    if (!this.initialized) {
                        T result = this.delegate.get();
                        this.initialized = true;
                        this.result = result;
                        this.delegate = null;
                    }
                }
            }
            return this.result;
        }
    }

    @FunctionalInterface
    private static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

