/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource.trundle;

import com.blamejared.contenttweaker.core.resource.trundle.TrundleException;
import com.blamejared.contenttweaker.core.resource.trundle.TrundleResource;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;

final class TrundleFile
extends TrundleResource {
    private byte[] contents;

    TrundleFile(String name, List<FileAttribute<?>> attributes) {
        this(name, new byte[0], attributes);
    }

    TrundleFile(String name, byte[] contents, List<FileAttribute<?>> attributes) {
        super(name, TrundleResource.Type.FILE, attributes);
        this.contents = Objects.requireNonNull(contents);
    }

    @Override
    void add(TrundleResource resource) {
        Objects.requireNonNull(resource);
        throw new TrundleException(TrundleException.Code.ADD_NOT_SUPPORTED, this.name() + " is not a directory");
    }

    @Override
    void remove(TrundleResource resource) {
        Objects.requireNonNull(resource);
        throw new TrundleException(TrundleException.Code.REMOVE_NOT_SUPPORTED, this.name() + " is not a directory");
    }

    @Override
    TrundleResource tryResolve(String name) {
        Objects.requireNonNull(name);
        throw new TrundleException(TrundleException.Code.ENUMERATION_NOT_SUPPORTED, this.name() + " is not a directory");
    }

    @Override
    byte[] contents() {
        return this.contents;
    }

    @Override
    long size() {
        return this.contents().length;
    }

    byte[] resizeContents(int amount) {
        if (amount != 0) {
            byte[] oldContents = this.contents;
            byte[] newContents = new byte[oldContents.length + amount];
            int length = Math.min(oldContents.length, newContents.length);
            System.arraycopy(oldContents, 0, newContents, 0, length);
            this.contents = newContents;
        }
        return this.contents();
    }
}

