/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.resource.UserPack;
import com.blamejared.contenttweaker.core.service.ServiceManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.bridge.game.GameVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;

public final class UserRepositorySource
implements class_3285 {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    private static final Path TARGET = ServiceManager.platform().gameDirectory().resolve("resources");
    private final class_3264 type;

    private UserRepositorySource(class_3264 type) {
        this.type = type;
    }

    public static UserRepositorySource of(class_3264 type) {
        return new UserRepositorySource(Objects.requireNonNull(type));
    }

    public void method_14453(Consumer<class_3288> consumer, class_3288.class_5351 packConstructor) {
        if (this.verify()) {
            return;
        }
        try {
            this.checkUserResources(consumer, packConstructor);
        }
        catch (IOException e) {
            ContentTweakerCore.LOGGER.warn("An error occurred while walking user resources", (Throwable)e);
        }
    }

    private boolean verify() {
        if (!Files.isDirectory(TARGET, new LinkOption[0])) {
            try {
                Files.deleteIfExists(TARGET);
                Files.createDirectory(TARGET, new FileAttribute[0]);
            }
            catch (IOException e) {
                ContentTweakerCore.LOGGER.error("An error occurred while trying to create user directory in " + TARGET + ": user resources won't be available", (Throwable)e);
                return true;
            }
        }
        return false;
    }

    private void checkUserResources(Consumer<class_3288> consumer, class_3288.class_5351 constructor) throws IOException {
        consumer.accept(this.pack(constructor));
    }

    private class_3288 pack(class_3288.class_5351 constructor) throws IOException {
        Path metadataPath = TARGET.resolve("pack.mcmeta");
        JsonObject metadata = this.readMetadata(metadataPath);
        String packId = ContentTweakerConstants.rl("user/" + this.type.name().toLowerCase(Locale.ENGLISH)).toString();
        class_3288 pack = class_3288.method_14456((String)packId, (boolean)true, () -> this.resources(metadata), (class_3288.class_5351)constructor, (class_3288.class_3289)class_3288.class_3289.field_14280, this::decorateSource);
        if (pack == null) {
            throw new IOException("Unable to create pack due to an unknown IO error", new NullPointerException());
        }
        return pack;
    }

    private JsonObject readMetadata(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, StandardOpenOption.READ));){
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                return jsonObject;
            }
        }
        return this.createMetadata();
    }

    private JsonObject createMetadata() {
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "ContentTweaker User Resources");
        pack.addProperty("pack_format", (Number)this.type.method_31438((GameVersion)class_155.method_16673()));
        meta.add("pack", (JsonElement)pack);
        return meta;
    }

    private class_3262 resources(JsonObject metadata) {
        class_3259 resources = new class_3259(TARGET.toFile());
        return new UserPack(GSON, "User Resources", (class_3262)resources, metadata);
    }

    private class_2561 decorateSource(class_2561 originalName) {
        return class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{originalName, class_2561.method_43471((String)ContentTweakerConstants.ln("pack_source.runtime"))});
    }
}

