/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.api.resource.ResourceFragment;
import com.blamejared.contenttweaker.core.resource.RuntimeFragment;
import com.blamejared.contenttweaker.core.service.ServiceManager;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.google.common.base.Suppliers;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Logger;

public final class RuntimeResourceDumpingCommand {
    private static final Supplier<Path> DUMP_ROOT = Suppliers.memoize(() -> ServiceManager.platform().gameDirectory().resolve("./ct_dumps/contenttweaker_resources"));

    private RuntimeResourceDumpingCommand() {
    }

    public static void register(ICommandRegistrationHandler handler) {
        handler.registerDump("contenttweaker_resources", class_2561.method_43471((String)ContentTweakerConstants.ln("command.dump_resources.desc")), RuntimeResourceDumpingCommand::buildCommand);
    }

    private static void buildCommand(LiteralArgumentBuilder<class_2168> builder) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(p -> p.method_9259(2))).then(class_2170.method_9247((String)"log").executes(RuntimeResourceDumpingCommand::executeLog))).then(class_2170.method_9247((String)"file").executes(RuntimeResourceDumpingCommand::executeFile))).executes(RuntimeResourceDumpingCommand::executeLog);
    }

    private static int executeLog(CommandContext<class_2168> context) {
        return RuntimeResourceDumpingCommand.execute(context, arg_0 -> ((Logger)CraftTweakerAPI.LOGGER).info(arg_0));
    }

    private static int executeFile(CommandContext<class_2168> context) {
        return RuntimeResourceDumpingCommand.execute(context, RuntimeResourceDumpingCommand::write);
    }

    private static int execute(CommandContext<class_2168> context, Consumer<VisitResult> executor) {
        Arrays.stream(class_3264.values()).map(ContentTweakerCore.core().resourceManager()::fragments).map(Map::values).flatMap(Collection::stream).map(RuntimeResourceDumpingCommand::gatherFragment).flatMap(Collection::stream).forEach(executor);
        CommandUtilities.send((class_2561)CommandUtilities.openingLogFile((class_5250)class_2561.method_43469((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable((class_5250)class_2561.method_43471((String)ContentTweakerConstants.ln("command.dump_resources.log"))), CommandUtilities.getFormattedLogFile()}).method_27692(class_124.field_1060)), (class_2168)((class_2168)context.getSource()));
        return 1;
    }

    private static List<VisitResult> gatherFragment(RuntimeFragment fragment) {
        ResourceFragment.Key key = fragment.key();
        ArrayList<VisitResult> outer = new ArrayList<VisitResult>();
        fragment.fs().getRootDirectories().forEach(root -> RuntimeResourceDumpingCommand.gatherFromRoot(root, outer, key));
        return outer;
    }

    private static void gatherFromRoot(Path root, List<VisitResult> outer, ResourceFragment.Key key) {
        try {
            Files.walkFileTree(root, new ResourceVisitor(root, key, outer::add));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void write(VisitResult result) {
        try {
            Path dumpPath = DUMP_ROOT.get().resolve(result.name());
            Path parent = dumpPath.getParent();
            Files.createDirectories(parent, new FileAttribute[0]);
            Files.copy(result.path(), dumpPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            CraftTweakerAPI.LOGGER.error(() -> "Unable to correctly dump resource %s due to an error".formatted(result.name()), (Throwable)e);
        }
    }

    private static final class ResourceVisitor
    extends SimpleFileVisitor<Path> {
        private final Path root;
        private final ResourceFragment.Key key;
        private final Consumer<Path> pathConsumer;

        ResourceVisitor(Path root, ResourceFragment.Key key, Consumer<VisitResult> resultConsumer) {
            this.root = root;
            this.key = key;
            this.pathConsumer = path -> this.pathToName((Path)path, resultConsumer);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            FileVisitResult result = super.visitFile(file, attrs);
            if (result != FileVisitResult.CONTINUE) {
                return result;
            }
            if (!attrs.isRegularFile()) {
                return FileVisitResult.CONTINUE;
            }
            DosFileAttributes attributes = Files.readAttributes(file, DosFileAttributes.class, new LinkOption[0]);
            if (attributes.isHidden()) {
                return FileVisitResult.CONTINUE;
            }
            this.pathConsumer.accept(file);
            return FileVisitResult.CONTINUE;
        }

        private void pathToName(Path path, Consumer<VisitResult> resultConsumer) {
            Path absolute = path.toAbsolutePath().normalize();
            Path targetPath = this.root.relativize(path.toAbsolutePath().normalize()).normalize();
            resultConsumer.accept(new VisitResult(absolute, "%s/%s/%s".formatted(this.key.type().method_14413(), this.key.id(), targetPath)));
        }
    }

    private record VisitResult(Path path, String name) {
    }
}

