/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import com.blamejared.contenttweaker.core.ContentTweakerCore;
import com.blamejared.contenttweaker.core.api.ContentTweakerConstants;
import com.blamejared.contenttweaker.core.resource.RuntimeFragment;
import com.blamejared.contenttweaker.core.resource.RuntimePack;
import com.blamejared.contenttweaker.core.resource.RuntimePackResources;
import com.blamejared.contenttweaker.core.resource.RuntimeResourceManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.bridge.game.GameVersion;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;

public final class RuntimeRepositorySource
implements class_3285 {
    private final class_3264 type;

    private RuntimeRepositorySource(class_3264 type) {
        this.type = type;
    }

    public static RuntimeRepositorySource of(class_3264 type) {
        Objects.requireNonNull(type);
        return new RuntimeRepositorySource(type);
    }

    public void method_14453(Consumer<class_3288> consumer, class_3288.class_5351 packConstructor) {
        RuntimeResourceManager manager = ContentTweakerCore.core().resourceManager();
        Map<String, RuntimeFragment> resources = manager.fragments(this.type);
        resources.forEach((namespace, fragment) -> consumer.accept(this.pack(this.type, (String)namespace, (RuntimeFragment)fragment, packConstructor)));
    }

    private class_3288 pack(class_3264 type, String id, RuntimeFragment fragment, class_3288.class_5351 constructor) {
        String packId = ContentTweakerConstants.rl("runtime/" + fragment.fsId().replace(':', '/')).toString();
        class_3288 pack = class_3288.method_14456((String)packId, (boolean)true, this.createPack(type, id, packId, fragment), (class_3288.class_5351)constructor, (class_3288.class_3289)class_3288.class_3289.field_14280, this::decorateSource);
        if (pack == null) {
            throw new IllegalStateException("An error occurred while generating runtime ContentTweaker pack '" + packId + "'");
        }
        return pack;
    }

    private Supplier<class_3262> createPack(class_3264 type, String target, String packId, RuntimeFragment fragment) {
        RuntimePack pack = new RuntimePack(packId, target, type, this.makeMetadata(type, packId, target), fragment::fs);
        return () -> new RuntimePackResources(pack);
    }

    private JsonObject makeMetadata(class_3264 type, String packId, String target) {
        JsonObject meta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "Runtime pack for " + target + " of type " + type.name());
        pack.addProperty("pack_format", (Number)this.makeFormat(type));
        meta.add("pack", (JsonElement)pack);
        JsonObject cotData = new JsonObject();
        cotData.addProperty("type", type.toString());
        cotData.addProperty("id", packId);
        cotData.addProperty("target", target);
        meta.add(ContentTweakerConstants.rl("data").toString(), (JsonElement)cotData);
        return meta;
    }

    private int makeFormat(class_3264 type) {
        return type.method_31438((GameVersion)class_155.method_16673());
    }

    private class_2561 decorateSource(class_2561 originalName) {
        return class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{originalName, class_2561.method_43471((String)ContentTweakerConstants.ln("pack_source.runtime"))});
    }
}

