/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.resource;

import java.util.Objects;

final class GeneratedResource<T> {
    private volatile Generator<T> generator;
    private volatile byte[] data;
    private volatile T resource;

    private GeneratedResource(Generator<T> generator, T resource) {
        this.generator = generator;
        this.resource = resource;
        this.data = null;
    }

    public static <T> GeneratedResource<T> of(T resource, Generator<T> generator) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(generator);
        return new GeneratedResource<T>(generator, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] data() {
        if (this.data == null) {
            GeneratedResource generatedResource = this;
            synchronized (generatedResource) {
                if (this.data == null) {
                    this.data = this.generator.from(this.resource);
                    if (this.data == null) {
                        throw new IllegalStateException("Generation of resource failed");
                    }
                    this.generator = null;
                    this.resource = null;
                }
            }
        }
        return this.data;
    }

    @FunctionalInterface
    static interface Generator<T> {
        public byte[] from(T var1);
    }
}

