/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.object.RegistryResolver;
import com.blamejared.contenttweaker.core.registry.ObjectTypeRegistry;
import com.blamejared.contenttweaker.core.util.FreezableMap;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class RegistryResolverRegistry {
    private final FreezableMap<ObjectType<?>, RegistryResolver<?>> resolvers = FreezableMap.of();

    RegistryResolverRegistry() {
    }

    public void registerResolvers(ObjectTypeRegistry objectTypeRegistry, Map<ObjectType<?>, RegistryResolver<?>> map) {
        Collection<ObjectType<?>> objectTypes = objectTypeRegistry.allTypes();
        List<ObjectType> unregisteredTypes = map.keySet().stream().filter(Predicate.not(objectTypes::contains)).toList();
        if (!unregisteredTypes.isEmpty()) {
            throw new IllegalStateException("Unknown object types " + unregisteredTypes);
        }
        this.resolvers.putAll(map);
        this.resolvers.freeze();
    }

    public <T> RegistryResolver<T> findResolverFor(ObjectType<T> type) {
        return (RegistryResolver)GenericUtil.uncheck(this.resolvers.get(type));
    }
}

