/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.util.FreezableMap;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class ObjectTypeRegistry {
    private final FreezableMap<class_2960, ObjectType<?>> typesById = FreezableMap.of();
    private final FreezableMap<class_5321<? extends class_2378<?>>, ObjectType<?>> typesByKey = FreezableMap.of();

    ObjectTypeRegistry() {
    }

    public void registerTypes(Map<class_2960, ObjectType<?>> types) {
        this.typesById.putAll(types);
        this.typesById.values().stream().filter(it -> it.key() != null).forEach(it -> this.typesByKey.put(it.key(), (ObjectType<?>)it));
        this.typesById.freeze();
        this.typesByKey.freeze();
    }

    @Nullable
    public <T> ObjectType<T> get(class_2960 id) {
        return (ObjectType)GenericUtil.uncheck(this.typesById.get(Objects.requireNonNull(id)));
    }

    @Nullable
    public <T> ObjectType<T> get(class_5321<? extends class_2378<T>> key) {
        return (ObjectType)GenericUtil.uncheck(this.typesByKey.get(key));
    }

    public Collection<ObjectType<?>> allTypes() {
        return this.typesById.values();
    }
}

