/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.registry;

import com.blamejared.contenttweaker.core.api.object.ObjectFactory;
import com.blamejared.contenttweaker.core.api.object.ObjectFactoryMapping;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.registry.ObjectTypeRegistry;
import com.blamejared.contenttweaker.core.util.FreezableMap;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class FactoryMappingsRegistry {
    private final FreezableMap<ObjectType<?>, ObjectFactoryMapping<?, ?>> factories = FreezableMap.of();

    FactoryMappingsRegistry() {
    }

    public void registerMappings(ObjectTypeRegistry objectTypeRegistry, Map<ObjectType<?>, ObjectFactoryMapping<?, ?>> map) {
        Collection<ObjectType<?>> objectTypes = objectTypeRegistry.allTypes();
        List<ObjectType> unregisteredTypes = map.keySet().stream().filter(Predicate.not(objectTypes::contains)).toList();
        if (!unregisteredTypes.isEmpty()) {
            throw new IllegalStateException("Unknown object types " + unregisteredTypes);
        }
        this.factories.putAll(map);
        this.factories.freeze();
    }

    public <T, U extends ObjectFactory<T>> ObjectFactoryMapping<T, U> findMappingFor(ObjectType<T> type) {
        return (ObjectFactoryMapping)GenericUtil.uncheck(this.factories.get(type));
    }
}

