/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.zen.object;

import com.blamejared.contenttweaker.core.api.ContentTweakerApi;
import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="contenttweaker.object.Reference")
@ZenRegister(loaders={"contenttweaker"})
public abstract class Reference<T> {
    private final ObjectType<T> type;
    private final class_2960 id;
    private T resolved;

    protected Reference(ObjectType<T> type, class_2960 id) {
        this.type = type;
        this.id = id;
        this.resolved = null;
    }

    @ZenCodeType.Getter(value="typeId")
    public final class_2960 typeId() {
        return this.type.id();
    }

    @ZenCodeType.Getter(value="registryId")
    public final @ZenCodeType.Nullable @Nullable class_2960 registryId() {
        return Optional.ofNullable(this.type().key()).map(class_5321::method_29177).orElse(null);
    }

    @ZenCodeType.Getter(value="id")
    public final class_2960 id() {
        return this.id;
    }

    public final ObjectType<T> type() {
        return this.type;
    }

    public final T get() {
        if (this.resolved == null) {
            this.resolved = ContentTweakerApi.get().registry().findResolver(this.type()).resolve(this.id());
        }
        if (this.resolved == null) {
            throw new IllegalStateException("Cannot resolve object at this time in %s".formatted(this));
        }
        return this.resolved;
    }

    public String toString() {
        return "Ref(%s/%s)".formatted(this.id(), this.type());
    }
}

