/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.zen.bracket;

import com.blamejared.contenttweaker.core.api.object.ObjectType;
import com.blamejared.contenttweaker.core.api.zen.bracket.BracketHelper;
import com.blamejared.contenttweaker.core.api.zen.bracket.ReferenceExpression;
import com.blamejared.contenttweaker.core.api.zen.object.Reference;
import com.blamejared.crafttweaker.api.util.ParseUtil;
import com.google.gson.reflect.TypeToken;
import java.util.Objects;
import net.minecraft.class_2960;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public final class ReferenceBracketExpressionParser<T, U extends Reference<T>>
implements BracketExpressionParser {
    private final String formatMessage;
    private final ObjectType<T> type;
    private final TypeToken<U> token;

    private ReferenceBracketExpressionParser(String formatMessage, ObjectType<T> type, TypeToken<U> token) {
        this.formatMessage = formatMessage;
        this.type = type;
        this.token = token;
    }

    public static <T, U extends Reference<T>> ReferenceBracketExpressionParser<T, U> of(String formatMessage, ObjectType<T> type, TypeToken<U> token) {
        return new ReferenceBracketExpressionParser<T, U>(Objects.requireNonNull(formatMessage), Objects.requireNonNull(type), Objects.requireNonNull(token));
    }

    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        String contents = ParseUtil.readBracketContent((CodePosition)position, (ZSTokenParser)tokens);
        if (contents.indexOf(58) == -1) {
            throw new ParseException(position, this.formatMessage.formatted(contents));
        }
        class_2960 location = BracketHelper.locationOrThrow(position, contents, () -> this.formatMessage.formatted(contents));
        return new ReferenceExpression<T, U>(position, this.type, this.token, location);
    }
}

