/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.contenttweaker.core.api.action;

import com.blamejared.contenttweaker.core.api.action.ContentTweakerAction;
import com.blamejared.contenttweaker.core.api.object.ObjectHolder;
import com.blamejared.contenttweaker.core.api.registry.RegistryButler;
import com.blamejared.contenttweaker.core.api.resource.ResourceManager;
import java.util.Objects;
import java.util.function.Consumer;

public final class RegisterObjectAction<T>
implements ContentTweakerAction {
    private final ObjectHolder<T> holder;
    private final Consumer<ResourceManager> resourceProvider;

    private RegisterObjectAction(ObjectHolder<T> holder, Consumer<ResourceManager> resourceProvider) {
        this.holder = holder;
        this.resourceProvider = resourceProvider;
    }

    public static <T> RegisterObjectAction<T> of(ObjectHolder<T> holder, Consumer<ResourceManager> resourceProvider) {
        return new RegisterObjectAction<T>(Objects.requireNonNull(holder), Objects.requireNonNull(resourceProvider));
    }

    public static <T> RegisterObjectAction<T> of(ObjectHolder<T> holder) {
        return RegisterObjectAction.of(holder, it -> {});
    }

    public void apply() {
        RegistryButler.get().register(this.holder);
        this.resourceProvider.accept(ResourceManager.get());
    }

    public String describe() {
        return "Registering object of type %s with name %s".formatted(this.holder.type(), this.holder.id());
    }
}

