package com.blamejared.contenttweaker.fabric.mixin;

import com.blamejared.contenttweaker.fabric.resource.FabricResourceManager;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;

@Mixin(value = class_3283.class, priority = 1001)
public abstract class PackRepositoryMixin {
    @Final
    @Mutable
    @Shadow
    private Set<class_3285> sources;

    @Inject(
            method = "<init>(Lnet/minecraft/server/packs/repository/Pack$PackConstructor;[Lnet/minecraft/server/packs/repository/RepositorySource;)V",
            at = @At(value = "RETURN")
    )
    private void contenttweaker$init$allowSourcesMutation(final class_3288.class_5351 packConstructor, final class_3285[] sources, final CallbackInfo info) {
        final Set<class_3285> previous = new HashSet<>(this.sources);
        this.sources = new LinkedHashSet<>(Arrays.asList(sources));
        this.sources.addAll(previous);
    }

    @Inject(
            method = "<init>(Lnet/minecraft/server/packs/PackType;[Lnet/minecraft/server/packs/repository/RepositorySource;)V",
            at = @At(value = "RETURN")
    )
    private void contenttweaker$init$injectCustomRepositorySources(final class_3264 type, final class_3285[] sources, final CallbackInfo info) {
        FabricResourceManager.inject(type, this.sources::add);
    }
}
